/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.io;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElementException;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.FruConfig;
import com.ibm.hwmca.fw.service.panel.CommonDataBean;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.panel.QueryAnd3ButtonGroupDataBean;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.service.managedsystem.fru.DefaultIOUnitPowerFru;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class IOUnitPowerFru
extends DefaultIOUnitPowerFru {
    protected String[] findOtherFruLocations(String fruType, int numLocs) {
        Trace.trace("XRVFRUNT", "<-> IOUnitPowerFru.find2FruLocations");
        String sEnclType = (String)this.getProperty("ENCLOSURE_TYPE");
        String sEnclModel = (String)this.getProperty("ENCLOSURE_MODEL");
        if (sEnclType == null) {
            Trace.trace("XRVFRUND", "getProperty(Fru.ENCLOSURE_TYPE) returned null.");
        }
        if (sEnclModel == null) {
            Trace.trace("XRVFRUND", "getProperty(Fru.ENCLOSURE_MODEL) returned null.");
        }
        String sBadFruLocation = (String)this.getProperty("LOCATION");
        try {
            int locStartIndex = sBadFruLocation.indexOf(45) + 1;
            int locEndIndex = sBadFruLocation.length();
            sBadFruLocation = sBadFruLocation.substring(locStartIndex, locEndIndex);
        }
        catch (StringIndexOutOfBoundsException e) {
            Trace.trace("XRVFRUNF", "Bad FRU property: LOCATION = " + (String)this.getProperty("LOCATION"));
            Trace.trace("XRVFRUNF", e.getMessage());
        }
        String sCecType = (String)this.getProperty("MANAGED_SYSTEM_TYPE");
        String sCecModel = (String)this.getProperty("MANAGED_SYSTEM_MODEL");
        FruConfig cecFruInfo = new FruConfig(sCecType, sCecModel);
        String[] asAllLocations = null;
        String sEnclMtms = "U" + sEnclType + "." + sEnclModel + ".1234567";
        try {
            asAllLocations = cecFruInfo.queryAllowableLocations(sEnclMtms, fruType);
        }
        catch (Exception e) {
            Trace.trace("XRVFRUNF", "Exception occurred in FruConfig.queryAllowableLocations(): " + e.getMessage());
        }
        if (asAllLocations.length != numLocs + 1) {
            Trace.trace("XRVFRUNF", "There are more possible locations than expected.  Possible = " + asAllLocations.length + ",  Expected = " + (numLocs + 1));
        }
        String[] asGoodLocs = new String[numLocs];
        int j = 0;
        for (int i = 0; i < asAllLocations.length; ++i) {
            if (asAllLocations[i].equalsIgnoreCase(sBadFruLocation)) continue;
            asGoodLocs[j] = asAllLocations[i];
            ++j;
        }
        return asGoodLocs;
    }

    public static QueryAnd3ButtonGroupDataBean displayPowerPanelSequence(List panelSequence, Map userData) throws HException {
        if (panelSequence != null) {
            GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
            CommonDataBean bean = null;
            int index = 0;
            int sequenceSize = panelSequence.size();
            while (index < sequenceSize) {
                bean = (CommonDataBean)panelSequence.get(index);
                String strButtonPressed = (bean = (CommonDataBean)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", bean.getTemplateName(), bean, userData)).getElementName();
                if (strButtonPressed.equalsIgnoreCase("ButtonNext")) {
                    ++index;
                    continue;
                }
                if (!strButtonPressed.equalsIgnoreCase("ButtonPrevious")) continue;
                index = index == 0 ? 0 : index - 1;
            }
            return (QueryAnd3ButtonGroupDataBean)bean;
        }
        return null;
    }

    public void displayServiceEffect(Map userInfo) throws ServiceableElementException {
        Trace.trace("XRVFRUNT", "<> IOUnitPowerFru.displayServiceEffect");
        LinkedList<CommonDataBean> panelSeq = new LinkedList<CommonDataBean>();
        CommonDataBean bean = null;
        while ((bean = this.getNextPowerRedundancyCheckBean(bean)) != null) {
            panelSeq.add(bean);
        }
        QueryAnd3ButtonGroupDataBean redunChkBean = null;
        try {
            redunChkBean = IOUnitPowerFru.displayPowerPanelSequence(panelSeq, userInfo);
            if (redunChkBean != null) {
                this.setRedundancy(redunChkBean);
                if (!redunChkBean.isThirdRadioButtonSelected()) {
                    super.displayServiceEffect(userInfo);
                }
            } else {
                Trace.trace("XRVFRUNF", "displayPowerPanelSequence() returned null.");
            }
        }
        catch (Exception e) {
            throw new ServiceableElementException(e);
        }
    }
}

